#
# C.O.R.E. Province Setup for v0.6 release
#  by Steel
#
#  This file contains all changes made to infra, ic, resources, manpower,
#  forts, coastal forts, anti-air and province resource stockpiles.
#
#  It does not contain any map changes such as location of port icons, 
#  adding beaches etc (these are still in province.csv).
#  



###  	Australia 1936 by A.B.Mathers

###	Fortifications already in place in 1936 and constantly improved upto 1939
###	Newcastle also had coastal forts, but since it has no beach, no point in placing.
###	After 1936 coastal forts improved in Darwin and Broome probably bringing 
###	them upto level 1 or more.  (Fortifications originally placed against Russian threat!)

province = { id = 2105 landfort = 0 coastalfort = 1 } #Brisbane
province = { id = 2075 landfort = 0 coastalfort = 1 } #Melbourne
province = { id = 2078 landfort = 0 coastalfort = 2 } #Sydney
province = { id = 2042 landfort = 0 coastalfort = 1 } #Perth

#Eben Emmel
province = {	id = 557	landfort = 2	}

# Czech

province = {	id = 613	landfort = 8	}
province = {	id = 578	landfort = 8	}
province = {	id = 616	landfort = 8	}
province = {	id = 617	landfort = 8	}


#Mannerheim line
province = {	id = 787	landfort = 2 }
province = {	id = 705	coastalfort = 1 }#Turkku
province = {	id = 706	coastalfort = 1 }#Helsinki


#Maginot line
province = {	id = 555	landfort = 10 }
province = {	id = 542	landfort = 10 }
province = {	id = 554	landfort = 10 }

#Germany
#Prussian resource stockpile
province = {  id = 646  oilpool = 500 supplypool = 2000 }

# Greece
province = {	id = 872	landfort = 2	} # was 5
province = {	id = 874	landfort = 2	} # was 5

# Italy
#Tobruk
province = {	id = 1097	landfort = 3 }
#Supply pools in Africa
province = {  id = 1285  oilpool = 100 supplypool = 5000 }
province = {  id = 1302  oilpool = 100 supplypool = 5000 }
province = {  id = 1087  oilpool = 500 supplypool = 5000 }

# Japan
#Korea resource stockpile
province = {  id = 1676  oilpool = 1000 supplypool = 2000 }

# Norway
province = {	id = 664	landfort = 0 coastalfort = 3 }#Oslofjorden
province = {	id = 674	landfort = 0 coastalfort = 2 }#Trondheim/Agdenes
province = {	id = 671	landfort = 0  coastalfort = 3 } #Bergen

# Philippines
#province = {	id = 1802	coastalfort = 5	} # removed as there is no beach
province = {	id = 1804	coastalfort = 5	}
province = {	id = 1800	coastalfort = 5	}

# Soviet
province = {	id = 788	landfort = 5 coastalfort = 5 antiair = 3 }#Leningrad
province = {	id = 846	landfort = 5 coastalfort = 0 antiair = 3 }#Moscow
province = {	id = 1225	landfort = 5 coastalfort = 0 antiair = 1 }#Stalingrad
province = {	id = 862	landfort = 3 coastalfort = 5 }#Sevestapol
province = {	id = 1663	landfort = 1 coastalfort = 3 }#Vladivostok

# Sweden
province = {	id = 2160	landfort = 0 coastalfort = 3 }#Stockholms Kustartillerifrsvar
province = {	id = 682	landfort = 3 coastalfort = 0 }#Bodens Fstning
province = {	id = 654	landfort = 0 coastalfort = 3 }#Karlkrona Kustartillerifrsvar
province = {	id = 653	landfort = 0 coastalfort = 1 }#Marindistrikt resund
province = {	id = 660	landfort = 0 coastalfort = 3 }#lvsborgs Kustartillerifrsvar
province = {	id = 691	landfort = 1 coastalfort = 0 }#Karlsborgs Fstning

#Swiss defenses
province = {	id = 564	landfort = 3 }
province = {	id = 541	landfort = 3 }
province = {	id = 914	landfort = 3 }
province = {	id = 936	landfort = 3 }


# United Kingdom
# Forts
# Singapore removed to assist Japanese AI
province = {	id = 503	landfort = 0 coastalfort = 3 }#Dover
province = {	id = 1717	landfort = 3 coastalfort = 0 }#Hong Kong
province = {	id = 1480	landfort = 0 coastalfort = 3 }#Ceylon
province = {	id = 989	landfort = 6  coastalfort = 6 } #gibraltar
province = {	id = 896	landfort = 0  coastalfort = 5 } #malta


#########################################################
#  Province resource changes
#########################################################

#Burma
province = {  id = 1580	coal = 15 }
province = {  id = 1588	ic = 2 maxic = 2  steel = 5 }
province = {  id = 1589	ic = 1 maxic = 1  rubber = 5 }
province = {  id = 1590	oil = 10  steel = 10 }
province = {  id = 1594	rubber = 5 }

#Ecuador
province = {  id = 292 manpower = 2 ic = 8 maxic = 8 infra = 0.30 maxinfra = 0.30 } # Quito
province = {  id = 291 manpower = 2 ic = 7 maxic = 7 infra = 0.40 maxinfra = 0.40 } # Guyaquil
province = {  id = 300 infra = 0.30 maxinfra = 0.30 } # Iquitos
# Port moved from Quito to Guyaquil in province.csv

#Karachi
# Port and beach added in province.csv, adj. seazone 1453.
#Abadan
# Port added in province.csv, adj. seazone 1351
#Bandar Abbas
# Port added in province.csv, adj. seazone 1416

#Egypt
province = { id = 1090 infra = 0.35 maxinfra = 0.35 } # Matruh
province = { id = 1091 infra = 0.35 maxinfra = 0.35 ic = 1 maxic = 1 } # Sidi Barrani
province = { id = 1092 infra = 0.35 maxinfra = 0.35 ic = 1 maxic = 1 manpower = 2 } # Bardiyah
province = { id = 1093 infra = 0.15 maxinfra = 0.15 manpower = 0 } # Al Quattara
province = { id = 1099 infra = 0.60 maxinfra = 0.60 steel = 6 manpower = 6 ic = 5 maxic = 5 } # Alexandria
province = { id = 1100 infra = 0.40 maxinfra = 0.50 steel = 3 manpower = 5 } # Port Said
province = { id = 1101 infra = 0.40 maxinfra = 0.50 steel = 14 ic = 13 maxic = 13 manpower = 8 } # Cairo
province = { id = 1102 infra = 0.40 maxinfra = 0.40 manpower = 1 ic = 1 maxic = 3 } # Suez
province = { id = 1103 infra = 0.35 maxinfra = 0.40 manpower = 3 coal = 10 } # Al Minyah. 
province = { id = 1104 infra = 0.15 maxinfra = 0.15 oil = 5 manpower = 0 } # Al Hariga
province = { id = 1200 infra = 0.35 maxinfra = 0.40 coal = 25 manpower = 4 ic = 1 maxic = 1 } # Assuan
province = { id = 1201 infra = 0.35 maxinfra = 0.35 coal = 9 manpower = 3 } # Sawhaj
province = { id = 1202 infra = 0.35 maxinfra = 0.35 oil = 8 ic = 1 maxic = 1 manpower = 2 } # Marsa El-Alam
province = { id = 1203 infra = 0.35 maxinfra = 0.40 coal = 6 manpower = 2 } # Al Qusiayah
province = { id = 1206 infra = 0.35 maxinfra = 0.35 coal = 3 oil = 15 manpower = 2 ic = 1 maxic = 1 } # El Arish

#Syria
province = { id = 1268 infra = 0.20 maxinfra = 0.20 oil = 6 manpower = 1 ic = 2 maxic = 2 } # Rawah
province = { id = 1269 infra = 0.50 maxinfra = 0.50 coal = 5 steel = 2 manpower = 4 ic = 2 maxic = 2 } # Aleppo
province = { id = 1270 infra = 0.30 maxinfra = 0.30 coal = 5 manpower = 3 ic = 1 maxic = 1 } # Homs
province = { id = 1274 infra = 0.35 maxinfra = 0.35 coal = 8 steel = 6 manpower = 5 ic = 4 maxic = 4 } # Damascus

#Lebanaon  
province = { id = 1273 infra = 0.35 maxinfra = 0.35 coal = 8 steel = 6 manpower = 5 ic = 4 maxic = 4 } # Beirut

#Spain
province = { id = 941 infra = 0.36 maxinfra = 0.36 } # Mahon
province = { id = 952 infra = 0.36 maxinfra = 0.36 manpower = 1 ic = 1 maxic = 1 } # Huesca
province = { id = 953 infra = 0.40 maxinfra = 0.40 manpower = 2 ic = 2 maxic = 2 } # Pamplona
province = { id = 954 infra = 0.46 maxinfra = 0.46 steel = 15 manpower = 6 ic = 10 maxic = 10 terrain = "mountain" } # Bilbao
province = { id = 956 infra = 0.36 maxinfra = 0.36 coal = 80 steel = 10 manpower = 1 ic = 4 maxic = 4 terrain = "mountain" } # Gijon
province = { id = 957 infra = 0.40 maxinfra = 0.40 coal = 40 manpower = 8 ic = 3 maxic = 3 } # Burgos
province = { id = 959 infra = 0.36 maxinfra = 0.36 coal = 40 manpower = 2 ic = 3 maxic = 3 terrain = "mountain" } # Vigo
province = { id = 966 infra = 0.40 maxinfra = 0.40 manpower = 1 ic = 2 maxic = 2 } # Valladolid
province = { id = 967 infra = 0.41 maxinfra = 0.41 manpower = 3 ic = 2 maxic = 2 } # Zaragoza
province = { id = 969 infra = 0.60 maxinfra = 0.60 coal = 30 manpower = 17 ic = 10 maxic = 10 } # Barcelona 
province = { id = 970 infra = 0.40 maxinfra = 0.40 manpower = 1 ic = 1 maxic = 1 } # Lleida
province = { id = 971 infra = 0.40 maxinfra = 0.40 coal = 5 steel = 5 manpower = 1 ic = 1 maxic = 1 } # Tortosa/Tarragona
province = { id = 972 infra = 0.60 maxinfra = 0.60 coal = 40 steel = 10 manpower = 17 ic = 8 maxic = 8 terrain = "hills" } # Madrid
province = { id = 977 infra = 0.38 maxinfra = 0.38 manpower = 1 ic = 1 maxic = 1 } # Badajoz
province = { id = 978 infra = 0.40 maxinfra = 0.40 manpower = 2 ic = 1 maxic = 1 terrain = "hills" } # Salamanca
province = { id = 980 infra = 0.40 maxinfra = 0.40 coal = 20 steel = 10 manpower = 2 ic = 1 maxic = 1 } # Cuenca
province = { id = 981 infra = 0.50 maxinfra = 0.50 manpower = 10 ic = 2 maxic = 2 } # Valencia
province = { id = 983 infra = 0.40 maxinfra = 0.40 manpower = 2 ic = 1 maxic = 1 } # Albacete
province = { id = 987 infra = 0.40 maxinfra = 0.40 manpower = 8 ic = 3 maxic = 3 } # Cordoba
province = { id = 988 infra = 0.50 maxinfra = 0.50 manpower = 8 ic = 5 maxic = 5 } # Sevilla
province = { id = 990 infra = 0.40 maxinfra = 0.40 manpower = 8 ic = 2 maxic = 2 } # Malaga
province = { id = 991 infra = 0.40 maxinfra = 0.40 manpower = 4 ic = 1 maxic = 1 } # Granada
province = { id = 995 infra = 0.40 maxinfra = 0.40 ic = 1 maxic = 1 } # Almeria
province = { id = 996 infra = 0.41 maxinfra = 0.41 manpower = 7 ic = 1 maxic = 1 } # Cartagena
province = { id = 997 infra = 0.40 maxinfra = 0.40 manpower = 1 ic = 1 maxic = 1 terrain = "hills" } # Palma de M.
province = { id = 998 infra = 0.36 maxinfra = 0.36 ic = 1 maxic = 1 } # San Francisco Javier
province = { id = 1000 infra = 0.40 maxinfra = 0.40 ic = 1 maxic = 1 } # Elvissa / Ibiza
province = { id = 1009 infra = 0.35 maxinfra = 0.35 ic = 1 maxic = 1 } # Ceuta
province = { id = 1017 infra = 0.35 maxinfra = 0.35 ic = 1 maxic = 1 } # Lanzarote
province = { id = 1018 infra = 0.35 maxinfra = 0.35 ic = 1 maxic = 1 } # Fuertaventura
province = { id = 1019 infra = 0.35 maxinfra = 0.35 ic = 1 maxic = 1 manpower = 1 } # Las Palmas
province = { id = 1020 infra = 0.35 maxinfra = 0.35 ic = 1 maxic = 1 } # Santa Cruz de Tenerife

#Saudi Arabia.  Removed ahistorical (?) coal/steel production and added world market trades.
province = { id = 1276 coal = 0 steel = 0 infra = 0.35 maxinfra = 0.35 }
province = { id = 1277 coal = 0 steel = 0 infra = 0.35 maxinfra = 0.35 }
province = { id = 1282 infra = 0.35 maxinfra = 0.35 } # Mecka (Saudi)
province = { id = 1349 infra = 0.35 maxinfra = 0.35 } # Az Zahran (Saudi

#Iraq.  Removed ahistorical (?) coal/steel production and added world market trades.
province = { id = 1267 coal = 0 steel = 0 } # Kirkuk
province = { id = 1272 coal = 0 steel = 0 } # Bagdad
province = { id = 1271 coal = 0 steel = 0 } # Mosul

#Switzerland.  Swiss economy is negative in all resources.
province = { id = 541 steel = 50 } # Bern

#Norway.  Steel production represents income from Swedish transit shipments (needed for coal/rubber buys)
province = { id = 680 steel = 80 } # Narvik. Paradox value is 160.

#Sweden.  Sweden is a major exporter of steel via Norway and Baltic ports.
province = { id = 681 steel = 230 } # Gallivare. Paradox value is 200. 50 iron put in Switzerland.

#Holland
# Supply pools
province = { id = 1780 oilpool = 100 supplypool = 100 }
province = { id = 1774 oilpool = 100 supplypool = 100 }
province = { id = 311 oilpool = 100 supplypool = 100 }
province = { id = 283 oilpool = 100 supplypool = 100 }

#UK
#Supply pools 
province = {  id = 1459	oilpool = 1000 supplypool = 2000 } # India (Bombay)
province = {  id = 989  oilpool = 100  supplypool = 500 } # Gibraltar
province = {  id = 896  oilpool = 100  supplypool = 500 } # Valetta(Malta)
province = {  id = 1717	oilpool = 100  supplypool = 500 } # Hong Kong
province = {  id = 1480	oilpool = 100  supplypool = 500 } # Colombo
province = {  id = 1766	oilpool = 100  supplypool = 500 } # Singapore
province = {  id = 222	oilpool = 100  supplypool = 500 } # Bermuda Islands
province = {  id = 1042	oilpool = 100  supplypool = 500 } # FreeTown
#UK colonial areas in Africa
province = { id = 1195 infra = 0.35 maxinfra = 0.35 } #Khartoum (UK) #1195 (base 09) 
province = { id = 1196 infra = 0.35 maxinfra = 0.35 } #Omdurman (UK) #1196 (base 09)
province = { id = 1199 infra = 0.35 maxinfra = 0.35 } #Kassala (UK) #1199 (base 09)
province = { id = 1146 infra = 0.35 maxinfra = 0.35 } #Lusaka (UK) #1146 (base 09)
province = { id = 1180 infra = 0.35 maxinfra = 0.35 } #Bulawayo (UK) #1180 (base 09)
province = { id = 1163 infra = 0.35 maxinfra = 0.35 } #Gaberones (UK) #1163 (base 09)

#Portugal
province = { id = 1999 infra = 0.35 maxinfra = 0.35 } #Tete (POR) #1999 (base 09)

#Belgium
province = { id = 1186 infra = 0.35 maxinfra = 0.35 } #Bakwanga (BEL) #1186 (base 09)
province = { id = 1129 infra = 0.35 maxinfra = 0.35 } #Coquilhatville (BEL) #1129 (base 00)

#ComChi forts
province = { id = 1570 ic = 4 maxic = 4 } # project = { type = 2 cost = 180 ic = 0 } removed
province = { id = 1571 ic = 6 maxic = 6 } # ComChi capital project = { type = 2 cost = 180 ic = 0 } removed

#Sinkiang upgrade in progress (stops first year panic build)
# province = { id = 1514 ic = 9 maxic = 9 project = { type = 0 cost = 360 ic = 0 } }

#Argentina
province = { id = 365 infra = 0.40 maxinfra = 0.40 ic = 4 maxic = 4 manpower = 3 } #Resistencia
province = { id = 369 infra = 0.35 maxinfra = 0.35 terrain = "marsh" ic = 2 maxic = 2 manpower = 1 rubber = 5 } #Corrientes
province = { id = 370 ic = 10 maxic = 10 manpower = 4 } #Santa Fe
province = { id = 373 infra = 0.35 maxinfra = 0.35 manpower = 2 } #San Miguel de Tucuman  climate = "mediterranean" 
province = { id = 374 terrain = "hills" infra = 0.60 maxinfra = 0.60 ic = 12 maxic = 12 } #Cordoba (add enough Victory Points for red star in the VP file)
province = { id = 380 infra = 0.40 maxinfra = 0.40 ic = 2 maxic = 2 manpower = 1 } #Mendoza (add enough Victory Points for red star in the VP file ???)
province = { id = 383 ic = 0 maxic = 0 } #General Roca
province = { id = 384 } #Buenos Aires No changes
province = { id = 385 infra = 0.60 maxinfra = 0.60 } #Mar del Plata
province = { id = 386 infra = 0.60 maxinfra = 0.60 } #Bahia Blanca
province = { id = 391 terrain = "desert" } #Trelew
province = { id = 392 infra = 0.30 maxinfra = 0.30 } #Junin de los Andes
province = { id = 396 terrain = "desert" Oil = 6 } #Comodoro Rivadavia
province = { id = 398 terrain = "desert" infra = 0.30 maxinfra = 0.35 coal = 20 } #San Julian  climate = "Subartic" 
province = { id = 401 ic = 0 maxic = 0 } #Lago Posadas
province = { id = 410 terrain = "hills" infra = 0.20 maxinfra = 0.20 ic = 0 maxic = 0 coal = 5 } # San Sebastian

#Persia
province = { id = 1358 infra = 0.45 maxinfra = 0.45 } #Tabriz 35----->45
province = { id = 1361 infra = 0.40 maxinfra = 0.40 } #Rasht 20----->40
province = { id = 1412 infra = 0.40 maxinfra = 0.40 } #Gorgan 20----->40
province = { id = 1410 infra = 0.35 maxinfra = 0.35 } #Mashhad 20----->35
province = { id = 1364 infra = 0.50 maxinfra = 0.50 } #Teheran 50----->50
province = { id = 1362 infra = 0.40 maxinfra = 0.40 } #Hamadan 20----->40
province = { id = 1363 infra = 0.40 maxinfra = 0.40 } #Qahremanshahr 35---->40
province = { id = 1357 infra = 0.40 maxinfra = 0.40 } #Esfahan 35----->40
province = { id = 1356 infra = 0.50 maxinfra = 0.50 } #Abadan 35----->50
province = { id = 1350 infra = 0.40 maxinfra = 0.40 } #Shiraz 35----->40
province = { id = 1413 infra = 0.35 maxinfra = 0.35 } #Kerman 35----->35
province = { id = 1414 infra = 0.40 maxinfra = 0.40 } #Bandar Abbas 60----->40 
province = { id = 1411 infra = 0.30 maxinfra = 0.30 } #Jandaq 20----->30
province = { id = 1406 infra = 0.25 maxinfra = 0.25 } #Yazd 20----->25
province = { id = 1407 infra = 0.25 maxinfra = 0.25 } #Birjand 20------>25

#USSR 
province = { id = 1530 coal = 20 steel = 20 } # Norilsk
province = { id = 1397 coal = 47 } # Akmolinsk 
province = { id = 1250 coal = 30 } # Uralsk
province = { id = 1855 coal = 60 } # Kamenskoje
province = { id = 1375 coal = 20 steel = 10 } # Nizjnij Tagil
province = { id = 1371 coal = 10 steel = 20 } # Magnitogorsk
province = { id = 1436 steel = 20 } # Stalinabad
province = { id = 1431 steel = 20 } # Frunze
province = { id = 1380 coal = 65 } # Vorkuta
province = { id = 792 steel = 10 } # Tichvin

#Sweden
province = {  id = 675	ic = 1 maxic = 1 }



#################### 1.05c changes ##########################
#Argentina
province = { id = 384   antiair = 2 } #Buenos Aires
province = { id = 369   antiair = 1 } #Corrientes
province = { id = 417   antiair = 1 } #Cordoba
#Australia
province = { id = 2095   antiair = 3 } #Darwin
province = { id = 2105   antiair = 1 } #Brisbane
province = { id = 2078   antiair = 3 } #Sydney
province = { id = 2076   antiair = 2 } #Canberra
province = { id = 2075   antiair = 3 } #Melbourne
province = { id = 2066   antiair = 2 } #Adelaide
province = { id = 2067   antiair = 1 } #Port Augusta
province = { id = 2042   antiair = 2 } #Perth
province = { id = 2003   antiair = 3 } #Port Moresby
province = { id = 2023   antiair = 1 } #Lae
province = { id = 2025   antiair = 2 } #New Britain
province = { id = 1966   antiair = 3 } #North Solomon Islands
#Austria
province = { id = 621   antiair = 2 } #Wien
province = { id = 610   antiair = 1 } #Salzburg
province = { id = 623   antiair = 1 } #Graz
#Belgium
province = { id = 557   antiair = 2 } #Arlon (Eben-Emael)
province = { id = 552   antiair = 1 } #Bruxelles
province = { id = 548   antiair = 2 } #Antwerpen
#Brazil
province = { id = 351   antiair = 2 } #Belo Horizonte
province = { id = 360   antiair = 2 } #Sao Paulo
province = { id = 356   antiair = 2 } #Rio de Janeiro
province = { id = 358   antiair = 1 } #Santos
#Canada
province = { id = 750   antiair = 2 } #Sofia
province = { id = 809   antiair = 1 } #Varna
province = { id = 128   antiair = 2 } #Ottawa
province = { id = 149   antiair = 1 } #Montral
province = { id = 154   antiair = 2 } #Qubec
province = { id = 2199  antiair = 1 } #Toronto
province = { id = 4     antiair = 1 } #Vancouver
#Colombia
province = { id = 281   antiair = 1 } #Cartagena
province = { id = 284   antiair = 2 } #Bogota
#Czechoslovakia
province = { id = 612   antiair = 2 } #Plzen
province = { id = 615   antiair = 3 } #Praha
province = { id = 619   antiair = 2 } #Slavkov/Brno
province = { id = 618   antiair = 1 } #Bratislava
#Denmark
province = { id = 594   antiair = 2 } #Kobenhavn
#Finland
province = { id = 706   antiair = 3 } #Helsinki
province = { id = 787   antiair = 2 } #Viipuri
province = { id = 803   antiair = 2 } #Sortalava
province = { id = 705   antiair = 1 } #Turku
province = { id = 702   antiair = 2 } #Mariehamm
#France
province = { id = 518   antiair = 1 } #Lille
province = { id = 520   antiair = 1 } #Sedan
province = { id = 527   antiair = 3 } #Paris
province = { id = 915   antiair = 1 } #Vichy
province = { id = 538   antiair = 2 } #Brest
province = { id = 536   antiair = 2 } #Nantes
province = { id = 948   antiair = 2 } #Bordeaux
province = { id = 929   antiair = 3 } #Marseille
province = { id = 543   antiair = 2 } #Nancy
province = { id = 556   antiair = 1 } #Chaumont
province = { id = 1081  antiair = 2 } #Tunis
province = { id = 1077  antiair = 2 } #Algiers
province = { id = 1011  antiair = 1 } #Casablanca
province = { id = 1033  antiair = 1 } #Dakar
province = { id = 1607  antiair = 2 } #Hanoi
province = { id = 1733  antiair = 1 } #Saigon
province = { id = 531   antiair = 1 } #Caen
province = { id = 532   antiair = 1 } #Cherbourg
#Germany
province = { id = 558   antiair = 2 } #Kln
province = { id = 559   antiair = 2 } #Essen
province = { id = 585   antiair = 2 } #Magdeburg
province = { id = 560   antiair = 2 } #Saarbrcken
province = { id = 1961   antiair = 2 } #Frankfurt-am-Main
province = { id = 575   antiair = 2 } #Mannheim
province = { id = 577   antiair = 1 } #Stuttgart
province = { id = 562   antiair = 1 } #Mnchen
province = { id = 574   antiair = 1 } #Nrnberg
province = { id = 589   antiair = 1 } #Wilhelmshafen
province = { id = 588   antiair = 2 } #Hamburg
province = { id = 586   antiair = 2 } #Kiel
province = { id = 587   antiair = 1 } #Lbeck
province = { id = 602   antiair = 2 } #Berlin
province = { id = 605   antiair = 1 } #Leipzig
province = { id = 650   antiair = 1 } #Knigsberg
#Greece
province = { id = 891   antiair = 2 } #Athinai
province = { id = 872   antiair = 2 } #Thessaloniki
#Holland
province = { id = 550   antiair = 2 } #Amsterdam
province = { id = 551   antiair = 2 } #Eindhoven
#Hungary
province = { id = 633   antiair = 2 } #Budapest
#Iraq
province = { id = 1272   antiair = 3 } #Bagdad
province = { id = 1271   antiair = 1 } #Mosul
#Italy
province = { id = 932   antiair = 3 } #Torino
province = { id = 933   antiair = 2 } #Genoa
province = { id = 912   antiair = 3 } #Milano
province = { id = 913   antiair = 2 } #La Spezia
province = { id = 567   antiair = 1 } #Venezia
province = { id = 910   antiair = 1 } #Parma
province = { id = 905   antiair = 1 } #Bologna
province = { id = 906   antiair = 1 } #Firenze
province = { id = 908   antiair = 3 } #Roma
province = { id = 901   antiair = 2 } #Napoli
province = { id = 893   antiair = 2 } #Taranto
province = { id = 897   antiair = 1 } #Messina
province = { id = 1085  antiair = 1 } #Tripoli
province = { id = 1097  antiair = 1 } #Tobruk
province = { id = 1098  antiair = 1 } #Benghazi
#Japan
province = { id = 1674   antiair = 2 } #Keijo
province = { id = 1561   antiair = 1 } #Dalian
province = { id = 1822   antiair = 4 } #Tokyo
province = { id = 1820   antiair = 2 } #Fukushima
province = { id = 1821   antiair = 2 } #Niigata
province = { id = 1819   antiair = 2 } #Sendai
province = { id = 1823   antiair = 3 } #Nagoya
province = { id = 1825   antiair = 4 } #Osaka
province = { id = 1716   antiair = 2 } #Taihoku
province = { id = 1812   antiair = 2 } #Bonin Islands
province = { id = 1937   antiair = 3 } #Mariane Islands
province = { id = 2002   antiair = 3 } #Caroline Islands
province = { id = 2035   antiair = 2 } #Truk Islands
province = { id = 1919   antiair = 3 } #Kwajalein
province = { id = 1899   antiair = 2 } #Eniwetok
province = { id = 1923   antiair = 3 } #Marshall Islands
#Mexico
province = { id = 244   antiair = 2 } #Ciudad de Mxico
province = { id = 237   antiair = 1 } #Monterey
province = { id = 242   antiair = 1 } #Guadalajara
#Norway
province = { id = 664   antiair = 2 } #Oslo
province = { id = 671   antiair = 1 } #Bergen
province = { id = 680   antiair = 2 } #Narvik
#Poland
province = { id = 606   antiair = 2 } #Poznan
province = { id = 645   antiair = 2 } #Danzig
province = { id = 639   antiair = 2 } #Lodz
province = { id = 638   antiair = 2 } #Krakow
province = { id = 643   antiair = 3 } #Warszawa
province = { id = 725   antiair = 2 } #Lwow
#Portugal
province = { id = 964   antiair = 1 } #Porto
province = { id = 975   antiair = 2 } #Lissabon
#Romania
province = { id = 763   antiair = 1 } #Chisinau
province = { id = 761   antiair = 2 } #Constanta
province = { id = 760   antiair = 3 } #Ploiesti
province = { id = 757   antiair = 3 } #Bucuresti
#South Africa
province = { id = 1175   antiair = 3 } #Johannesburg
province = { id = 1172   antiair = 1 } #Durban
province = { id = 1167   antiair = 1 } #Port Elizabeth
province = { id = 1156   antiair = 2 } #Cape Town
#USSR
province = { id = 791   antiair = 1 } #Novgorod
province = { id = 822   antiair = 2 } #Murmansk
province = { id = 839   antiair = 2 } #Archangelsk
province = { id = 784   antiair = 2 } #Vitebsk
province = { id = 781   antiair = 3 } #Smolensk
province = { id = 778   antiair = 3 } #Minsk
province = { id = 779   antiair = 2 } #Mogiljov
province = { id = 856   antiair = 2 } #Bryansk
province = { id = 852   antiair = 1 } #Kaluga
province = { id = 772   antiair = 1 } #Bobrujsk
province = { id = 776   antiair = 2 } #Chernigov
province = { id = 775   antiair = 3 } #Kiev
province = { id = 764   antiair = 3 } #Odessa
province = { id = 865   antiair = 2 } #Dnepropetrovsk
province = { id = 862   antiair = 3 } #Sevastopol
province = { id = 857   antiair = 1 } #Kharkov
province = { id = 861   antiair = 2 } #Rostov
province = { id = 1227  antiair = 1 } #Voronezh
province = { id = 847   antiair = 2 } #Vladimir
province = { id = 850   antiair = 2 } #Nizjnij Novgorod
province = { id = 1220  antiair = 1 } #Batumi
province = { id = 1266  antiair = 1 } #Jerevan
province = { id = 1359  antiair = 3 } #Baku
province = { id = 1373  antiair = 3 } #Kujbysjev
province = { id = 1371  antiair = 3 } #Magnitogorsk
province = { id = 1663  antiair = 3 } #Vladivostok
#Spain
province = { id = 988   antiair = 2 } #Sevilla
province = { id = 972   antiair = 3 } #Madrid
province = { id = 957   antiair = 2 } #Burgos
province = { id = 956   antiair = 2 } #Gijon
province = { id = 969   antiair = 2 } #Barcelona
province = { id = 981   antiair = 2 } #Valencia
province = { id = 1009  antiair = 1 } #Ceuta
#Sweden
province = { id = 653   antiair = 1 } #Malm
province = { id = 660   antiair = 2 } #Gteborg
province = { id = 2160  antiair = 3 } #Stockholm
#Switzerland
province = { id = 541   antiair = 3 } #Bern
province = { id = 561   antiair = 3 } #Zrich
province = { id = 914   antiair = 3 } #Lausanne
province = { id = 936   antiair = 3 } #Genve
#UK
province = { id = 499   antiair = 3 } #London
province = { id = 498   antiair = 2 } #Coventry
province = { id = 503   antiair = 2 } #Portsmouth
province = { id = 502   antiair = 2 } #Southampton
province = { id = 501   antiair = 2 } #Plymouth
province = { id = 497   antiair = 2 } #Birmingham
province = { id = 489   antiair = 2 } #Manchester
province = { id = 486   antiair = 1 } #Glasgow
province = { id = 989   antiair = 2 } #Gibraltar
province = { id = 1099  antiair = 2 } #Alexandria
province = { id = 1100  antiair = 2 } #Port Said
province = { id = 1101  antiair = 2 } #Cairo
province = { id = 1102  antiair = 2 } #Suez
province = { id = 1205  antiair = 1 } #Jeruzalem
province = { id = 1717  antiair = 2 } #Hong Kong
province = { id = 1766  antiair = 2 } #Singapore
province = { id = 1590  antiair = 1 } #Rangoon
province = { id = 1490  antiair = 1 } #Calcutta
province = { id = 1446  antiair = 1 } #Delhi
#USA
province = { id = 181   antiair = 3 } #Norfolk
province = { id = 178   antiair = 3 } #Washington DC
province = { id = 177   antiair = 2 } #Philadelphia
province = { id = 124   antiair = 3 } #New York
province = { id = 125   antiair = 2 } #Boston
province = { id = 187   antiair = 2 } #Chicago
province = { id = 92    antiair = 2 } #Los Angeles
province = { id = 158   antiair = 2 } #San Francisco
province = { id = 22    antiair = 2 } #Honolulu
province = { id = 288   antiair = 2 } #Coln
province = { id = 1889  antiair = 2 } #Wake
province = { id = 1942  antiair = 2 } #Guam
#Venezuela
province = { id = 282   antiair = 1 } #Maracaibo
province = { id = 237   antiair = 2 } #Caracas
#Yugoslavia
province = { id = 624   antiair = 2 } #Zagreb
province = { id = 740   antiair = 1 } #Osijek
province = { id = 738   antiair = 2 } #Beograd
province = { id = 743   antiair = 1 } #Split
province = { id = 747   antiair = 2 } #Dubrovnik



